/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.h14199.engine.SysProperties;
import org.h14199.message.DbException;
import org.h14199.store.fs.FileDisk;
import org.h14199.store.fs.FilePath;
import org.h14199.store.fs.FileUtils;
import org.h14199.util.IOUtils;

public class FilePathDisk
extends FilePath {
    private static final String CLASSPATH_PREFIX = "classpath:";

    @Override
    public FilePathDisk getPath(String string) {
        FilePathDisk filePathDisk = new FilePathDisk();
        filePathDisk.name = FilePathDisk.translateFileName(string);
        return filePathDisk;
    }

    @Override
    public long size() {
        if (this.name.startsWith(CLASSPATH_PREFIX)) {
            try {
                URL uRL;
                Object object = this.name.substring(CLASSPATH_PREFIX.length());
                if (!((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
                if ((uRL = this.getClass().getResource((String)object)) != null) {
                    return Files.size(Paths.get(uRL.toURI()));
                }
                return 0L;
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return new File(this.name).length();
    }

    protected static String translateFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("file:")) {
            string = string.substring("file:".length());
        }
        return FilePathDisk.expandUserHomeDirectory(string);
    }

    public static String expandUserHomeDirectory(String object) {
        if (((String)object).startsWith("~") && (((String)object).length() == 1 || ((String)object).startsWith("~/"))) {
            String string = SysProperties.USER_HOME;
            object = string + ((String)object).substring(1);
        }
        return object;
    }

    @Override
    public void moveTo(FilePath filePath, boolean bl) {
        File file = new File(this.name);
        File file2 = new File(filePath.name);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return;
        }
        if (!file.exists()) {
            throw DbException.get(90024, this.name + " (not found)", filePath.name);
        }
        if (bl) {
            boolean bl2 = file.renameTo(file2);
            if (bl2) {
                return;
            }
            throw DbException.get(90024, this.name, filePath.name);
        }
        if (file2.exists()) {
            throw DbException.get(90024, this.name, filePath + " (exists)");
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("rename", this.name + " >" + filePath, null);
            boolean bl3 = file.renameTo(file2);
            if (bl3) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90024, this.name, filePath.name);
    }

    private static void wait(int n) {
        if (n == 8) {
            System.gc();
        }
        try {
            long l = Math.min(256, n * n);
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                FilePathDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return new File(this.name).exists();
    }

    @Override
    public void delete() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("delete", this.name, null);
            boolean bl = file.delete();
            if (bl || !file.exists()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90025, this.name);
    }

    @Override
    public List<FilePath> newDirectoryStream() {
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>();
        File file = new File(this.name);
        try {
            String[] stringArray = file.list();
            if (stringArray != null) {
                Object object = file.getCanonicalPath();
                if (!((String)object).endsWith(SysProperties.FILE_SEPARATOR)) {
                    object = (String)object + SysProperties.FILE_SEPARATOR;
                }
                arrayList.ensureCapacity(stringArray.length);
                for (String string : stringArray) {
                    arrayList.add(this.getPath((String)object + string));
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    @Override
    public boolean canWrite() {
        return FilePathDisk.canWriteInternal(new File(this.name));
    }

    @Override
    public boolean setReadOnly() {
        File file = new File(this.name);
        return file.setReadOnly();
    }

    @Override
    public FilePathDisk toRealPath() {
        try {
            String string = new File(this.name).getCanonicalPath();
            return this.getPath(string);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.name);
        }
    }

    @Override
    public FilePath getParent() {
        String string = new File(this.name).getParent();
        return string == null ? null : this.getPath(string);
    }

    @Override
    public boolean isDirectory() {
        return new File(this.name).isDirectory();
    }

    @Override
    public boolean isAbsolute() {
        return new File(this.name).isAbsolute();
    }

    @Override
    public long lastModified() {
        return new File(this.name).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWriteInternal(File file) {
        try {
            if (!file.canWrite()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void createDirectory() {
        File file = new File(this.name);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            if (file.exists()) {
                if (file.isDirectory()) {
                    return;
                }
                throw DbException.get(90062, this.name + " (a file with this name already exists)");
            }
            if (file.mkdir()) {
                return;
            }
            FilePathDisk.wait(i);
        }
        throw DbException.get(90062, this.name);
    }

    @Override
    public OutputStream newOutputStream(boolean bl) throws IOException {
        try {
            File file = new File(this.name);
            File file2 = file.getParentFile();
            if (file2 != null) {
                FileUtils.createDirectories(file2.getAbsolutePath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.name, bl);
            IOUtils.trace("openFileOutputStream", this.name, fileOutputStream);
            return fileOutputStream;
        }
        catch (IOException iOException) {
            FilePathDisk.freeMemoryAndFinalize();
            return new FileOutputStream(this.name);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        if (this.name.matches("[a-zA-Z]{2,19}:.*")) {
            if (this.name.startsWith(CLASSPATH_PREFIX)) {
                InputStream inputStream;
                Object object = this.name.substring(CLASSPATH_PREFIX.length());
                if (!((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
                if ((inputStream = this.getClass().getResourceAsStream((String)object)) == null) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(((String)object).substring(1));
                }
                if (inputStream == null) {
                    throw new FileNotFoundException("resource " + (String)object);
                }
                return inputStream;
            }
            URL uRL = new URL(this.name);
            return uRL.openStream();
        }
        FileInputStream fileInputStream = new FileInputStream(this.name);
        IOUtils.trace("openFileInputStream", this.name, fileInputStream);
        return fileInputStream;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        for (int i = 0; i < 16; ++i) {
            runtime.gc();
            long l2 = runtime.freeMemory();
            runtime.runFinalization();
            if (l2 == l) break;
            l = l2;
        }
    }

    @Override
    public FileChannel open(String string) throws IOException {
        FileDisk fileDisk;
        try {
            fileDisk = new FileDisk(this.name, string);
            IOUtils.trace("open", this.name, fileDisk);
        }
        catch (IOException iOException) {
            FilePathDisk.freeMemoryAndFinalize();
            try {
                fileDisk = new FileDisk(this.name, string);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
        return fileDisk;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String string, boolean bl) throws IOException {
        File file;
        String string2 = this.name + ".";
        String string3 = new File(string2).getName();
        File file2 = bl ? new File(System.getProperty("java.io.tmpdir", ".")) : new File(string2).getAbsoluteFile().getParentFile();
        FileUtils.createDirectories(file2.getAbsolutePath());
        while ((file = new File(file2, string3 + FilePathDisk.getNextTempFileNamePart(false) + string)).exists() || !file.createNewFile()) {
            FilePathDisk.getNextTempFileNamePart(true);
        }
        return FilePathDisk.get(file.getCanonicalPath());
    }
}

